<?php

namespace Snapfile\Entities;

use Illuminate\Database\Eloquent\Model;

class File extends Model 
{

    protected $table = 'files';
    public $timestamps = true;
    protected $guarded = array('compression_options', 'encryption_options', 'storage_provider', 'storage_path');
    protected $fillable = array('file_type_id', 'user_id', 'service_profile_id', 'name', 'encryption_algorithm', 'compression_algorithm');
    protected $visible = array('file_type_id', 'user_id', 'service_profile_id', 'name', 'size', 'encryption_algorithm', 'compression_algorithm');
    protected $hidden = array('compression_options', 'encryption_options', 'storage_provider', 'storage_path');

    public function ownerUser()
    {
        return $this->belongsTo('Snapfile\Entities\User\User', 'user_id');
    }

    public function personalFolders()
    {
        return $this->belongsToMany('Snapfile\Entities\User\PersonalFolder', 'personal_folder_files');
    }

    public function shares()
    {
        return $this->hasMany('Snapfile\Entities\FileShare', 'file_id');
    }

    public function reminders()
    {
        return $this->hasMany('Snapfile\Entities\FileReminder', 'file_id');
    }

    public function ownerServiceProfile()
    {
        return $this->belongsTo('Snapfile\Entities\Business\ServiceProfile', 'service_profile_id');
    }

    public function type()
    {
        return $this->belongsTo('Snapfile\Entities\FileType', 'file_type_id');
    }

}